/*
 * Decompiled with CFR 0.152.
 */
package com.dao;

import com.Application;
import com.dao.CustomerDao;
import com.dao.HolooSettingsDao;
import com.dao.SideGroupDao;
import com.dao.process.CustomerProcessDao;
import com.dao.process.ProcessDao;
import com.dto.CustomerAddressDto;
import com.dto.CustomerDto;
import com.dto.CustomerVasetehDto;
import com.dto.LoginDto;
import com.google.gson.Gson;
import com.service.SettingLoader;
import com.utility.CallApi;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.JsonDeserializer;
import com.utility.LockCode;
import com.utility.LockReader;
import com.utility.MyHolooMessageMaker;
import com.utility.Paging;
import com.utility.ScriptRunner;
import com.utility.StringUtilsKt;
import com.utility.TextNormalizer;
import com.utility.TncException;
import com.utility.TncExceptionMessages;
import com.utility.TncJdbc;
import com.utility.TransactionCheck;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionStatus;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class CustomerDao {
    private final DbConnection dbConnection;
    private final ScriptRunner scriptRunner;
    private final HolooSettingsDao settingDao;
    private final Application app;

    public ResponseEntity<Map<Object, List<Map<String, Object>>>> getCustomerList(HttpServletRequest request, int itemsPerPage, int page) {
        LoginDto myLogin = this.dbConnection.setToken();
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(myLogin);
        Paging paging = new Paging(itemsPerPage, page, "CUSTOMER");
        SettingLoader settingLoader = new SettingLoader(this.dbConnection, myLogin);
        this.scriptRunner.runScript(myLogin);
        LockReader lockReader = new LockReader(jdbcTemplate);
        boolean chequeCashDateEnabled = myLogin.getIsTorfehNegar() == false && lockReader.isLockEnabled(LockCode.CHEQUE_CASH_DATE);
        String cashedChequeSelect = (chequeCashDateEnabled ? ", isNull(Ch2.cust, 0)" : ", 0") + " sumFloatNotCashedCheques";
        String sqlStr = " SELECT C_Code_C Code, C.C_Name Name, National_Code NationalId, Economic_Code EconomicId, \n        Col_Code_Bed + Moien_Code_Bed + Tafzili_Code_Bed BedSarfasl, \n        Col_Code_Bes + Moien_Code_Bes + Tafzili_Code_Bes BesSarfasl, \n        Kharid IsPurchaser, Forosh IsSeller, inlistsiah IsBlackList, Isnull(Vaseteh,0) IsVaseteh,city.City_Code CityCode ,city.[name] CityName, \n        Isnull(C.Vaseteh_Porsant,0) VasetehPorsant, \n" + (myLogin.getIsTorfehNegar() != false ? "0.0 Mandeh," : "Round(Isnull(Mandeh, 0), 0) Mandeh, \n") + "        Etebar Credit, C_Tel Tel, C_Mobile Mobile, C_Fax Fax, Cust_City City, \n        CityCodeLevy CityCodeLevy, Cust_Ostan Ostan, OstanCodeLevy OstanCode, \n        Cust_Mantagheh Mantagheh, Zip_Code ZipCode, C_Address Address, Cust_Job Job, \n        Birth_Date BirthDate, Email_Address Email, C.C_Code ErpCode, WebId, C.C_TYPE [type], \n        C.IsActive [IsActive], FF.F_Date lastSellPrice, FK.F_DATE lastBuyPrice, \n        C.SelectType selectedPriceType, ISNULL(isSeller, 0) isAmer,\n        isNull(Ch.Cust, 0) sumFloatCheques " + cashedChequeSelect + (myLogin.getIsTorfehNegar() == false ? " , (IsNull(V.Mandeh, 0) + IsNull(Ch.cust, 0)) AS debtInCheques, \n        (isNull(C.Etebar, 0) - (IsNull(V.Mandeh, 0) + IsNull(Ch.cust, 0))) AS creditDiff \n" : "") + (myLogin.getIsTorfehNegar() != false || myLogin.getIsMyHoloo() != false ? ", 0 groupCount" : ", (select count(*)  from CustomerGroup c left join CustomerGroup CG on CG.GroupID = C.GroupId) groupCount") + (myLogin.getIsTorfehNegar() != false || myLogin.getIsMyHoloo() != false ? ", 0 vasetehCount" : ", (SELECT count(*) From Customervaseteh cv where c_code = c.c_code and cv.Agent = 0 ) vasetehCount") + (myLogin.getIsTorfehNegar() != false || myLogin.getIsMyHoloo() != false ? ", 0 AgentCount" : ", (SELECT count(*) From Customervaseteh cv where c_code = c.c_code and cv.Agent = 1 ) AgentCount") + (myLogin.getIsMyHoloo() != false ? ", CONVERT(bit, 1) sellerWithTax" : ", sellerWithTax \n") + "       From customer C \n" + (myLogin.getIsTorfehNegar() != false ? "" : "Left join W0_Calc_BedBes_UseInView V on V.c_code=C.c_code \n") + "       LEFT JOIN (SELECT TOP 1 dbo.MiladiToShamsi(FAC_DATE) F_DATE, C_CODE FROM FACTURE \n        WHERE FAC_TYPE = 'F' ORDER BY FAC_DATE DESC) FF on FF.C_CODE = C.C_CODE       LEFT JOIN (SELECT TOP 1 dbo.MiladiToShamsi(FAC_DATE) F_DATE, C_CODE FROM FACTURE \n        WHERE FAC_TYPE = 'K' ORDER BY FAC_DATE DESC) FK on FK.C_CODE = C.C_CODE \n        LEFT JOIN CITY city on city.CITY_CODE = C.City_Code  \n       LEFT JOIN (SELECT C_Code_Source, Sum(isNull(Cust, 0)) cust FROM [Check] \n        WHERE Daryaft_Pardakht = 1 AND vosool = 0 \n        GROUP BY c_Code_Source) Ch on Ch.C_Code_Source = C.C_code \n" + (chequeCashDateEnabled ? " LEFT JOIN (Select C_Code_Source,Sum(isnull(Cust,0)) cust from [Check] \n        Where Daryaft_Pardakht = 1 AND ((Vosool = 0) Or ((Vosool = 1) And (Sel_Check = 1) And (Isnull(VosolKharji,0) = 0))) \n        group by c_Code_Source) Ch2 ON Ch2.C_Code_Source = C.C_code" : "");
        String sqlWhere = this.getFilter(request);
        if (!myLogin.getIsTorfehNegar().booleanValue() && !myLogin.getIsMyHoloo().booleanValue() && settingLoader.isMoienFilterEnabled()) {
            if (sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " WHERE ";
            }
            sqlWhere = sqlWhere + " City_Code NOT IN (select [value] from dbo.StringSplit(@cityCodes,',')) ";
        }
        sqlStr = paging.makeSql(Paging.PageSqlData.builder().declare(settingLoader.isMoienFilterEnabled() ? " DECLARE @cityCodes NVARCHAR(300)=(SELECT CityCodesFilter from USERDB where UserCodeInc = " + settingLoader.getLogin().getUserCodeInc() + ") \n" : "").selectSqlStr(sqlStr).whereStr(sqlWhere).keyField("ErpCode").keyFieldType("varchar(5)").alias("C").build());
        List rowSet = jdbcTemplate.queryForList(sqlStr);
        for (Map map : rowSet) {
            Object cCode = map.get("ErpCode");
            if (cCode == null) continue;
            if ((Integer)map.get("vasetehCount") > 0) {
                map.put("Vaseteh", this.getMidMenAttributes((String)cCode, (JdbcTemplate)jdbcTemplate, 0));
            }
            if ((Integer)map.get("AgentCount") > 0) {
                map.put("Agent", this.getMidMenAttributes((String)cCode, (JdbcTemplate)jdbcTemplate, 1));
            }
            if ((Integer)map.get("groupCount") > 0) {
                map.put("Groups", this.getGroupNameAttributes((String)cCode, (JdbcTemplate)jdbcTemplate));
            }
            map.put("ErpCode", ConvertStr.encrypt((String)cCode.toString()));
            map.remove("vasetehCount");
            map.remove("AgentCount");
            map.remove("groupCount");
        }
        return ConvertStr.getMapResponseEntity((String)"Customer", (List)rowSet, (boolean)TextNormalizer.isFarsi((HttpServletRequest)request));
    }

    private List<Map<String, Object>> getMidMenAttributes(String cCode, JdbcTemplate jdbcTemplate, int agent) {
        List midMan = jdbcTemplate.queryForList(" SELECT CU.C_CODE ErpCode, CU.C_NAME name, CU.C_Tel tel, CU.Comment description , CU.Vaseteh_Porsant vaseteh_porsant,  ISNULL(W.Mandeh, 0) remain  FROM CUSTOMER CU  LEFT JOIN W0_Calc_BedBes_UseInView W ON W.C_CODE = CU.C_CODE  WHERE CU.C_CODE IN (SELECT VASETEH_CODE FROM CUSTOMERVASETEH  WHERE C_CODE = ? and CU.Agent = ?) ", new Object[]{cCode, agent});
        for (Map m : midMan) {
            m.put("ErpCode", ConvertStr.encrypt((String)((String)m.get("ErpCode"))));
        }
        return midMan;
    }

    private List<Map<String, Object>> getGroupNameAttributes(String cCode, JdbcTemplate jdbcTemplate) {
        List midMan = jdbcTemplate.queryForList("select C.GroupID ID, C.GroupName Name  from CustomerGroup c left join Customer CG on ','+ CG.GroupID+',' like '%,' +CONVERT(nvarchar,C.GroupID)+',%' where CG.C_Code = ? \n", new Object[]{cCode});
        return midMan;
    }

    public ResponseEntity<Map<String, Object>> getCustomerCount() {
        Integer count = (Integer)this.dbConnection.getJdbcTemplate(this.dbConnection.setToken()).queryForObject("SELECT COUNT(C_CODE) FROM CUSTOMER", Integer.class);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("totalCount", count == null ? 0 : count);
        return ResponseEntity.ok(map);
    }

    public ResponseEntity<?> getCustomerAddress(HttpServletRequest request) {
        LoginDto login = this.dbConnection.setToken();
        String sql = "SELECT C.C_CODE customerErpCode, IsNull(C.C_ADDRESS, '') C_ADDRESS0, \n IsNull(T.C_ADDRESS1, '') C_ADDRESS1, IsNull(T.C_ADDRESS2, '') C_ADDRESS2, \n IsNull(T.C_ADDRESS3, '') C_ADDRESS3, IsNull(T.C_ADDRESS4, '') C_ADDRESS4, \n IsNull(T.C_ADDRESS5, '') C_ADDRESS5, C_AddressTitle '0', C_AddressTitle1 '1', \n C_AddressTitle2 '2', C_AddressTitle3 '3', C_AddressTitle4 '4', C_AddressTitle5 '5' \n FROM CUSTOMER C \n INNER JOIN CUST_TELL T ON C.C_CODE = T.CCode WHERE (C.C_ADDRESS <> '' OR \n T.C_ADDRESS1 <> '' OR T.C_ADDRESS2 <> '' OR T.C_ADDRESS3 <> '' OR \n T.C_ADDRESS4 <> '' OR T.C_ADDRESS5 <> '') \n";
        Map params = ConvertStr.rebuildQueryString((HttpServletRequest)request);
        if (params.containsKey("customererpcode")) {
            sql = sql + " AND C.C_CODE = '" + ConvertStr.decrypt((String)((String)params.get("customererpcode"))) + "'";
        }
        List addresses = this.dbConnection.getJdbcTemplate(login).queryForList(sql);
        for (Map address : addresses) {
            address.put("customerErpCode", ConvertStr.encrypt((String)((String)address.get("customerErpCode"))));
            address.put("addresses", this.makeAddressMapList(address));
        }
        return ConvertStr.getMapResponseEntity((String)"customerAddress", (List)addresses, (boolean)true);
    }

    private List<Map<String, String>> makeAddressMapList(Map<String, Object> address) {
        ArrayList<Map<String, String>> addressMapList = new ArrayList<Map<String, String>>();
        for (int i = 0; i <= 5; ++i) {
            String addressValue = (String)ConvertStr.removeFromMapOrDefault(address, (Object)("C_ADDRESS" + i), (Object)"");
            if (addressValue.isEmpty()) continue;
            String titleValue = (String)ConvertStr.removeFromMapOrDefault(address, (Object)String.valueOf(i), (Object)"");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("address", addressValue);
            map.put("title", titleValue);
            map.put("id", String.valueOf(i + 1));
            addressMapList.add(map);
        }
        return addressMapList;
    }

    public ResponseEntity<?> deleteCustomer(String[] erpCodes) {
        LoginDto login = this.dbConnection.setToken();
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(login);
        ArrayList deletedErpCodes = new ArrayList();
        ArrayList errors = new ArrayList();
        String sql = " EXEC DBO.DeleteCustomer ?";
        String[] decryptedCodes = new String[erpCodes.length];
        for (int i = 0; i < erpCodes.length; ++i) {
            decryptedCodes[i] = ConvertStr.decrypt((String)erpCodes[i].trim());
        }
        return (ResponseEntity)this.dbConnection.getTransactionTemplate(login).execute(arg_0 -> this.lambda$deleteCustomer$0((JdbcTemplate)jdbcTemplate, login, decryptedCodes, sql, errors, deletedErpCodes, arg_0));
    }

    private Map<String, Object> makeDeleteErrorMessage(Map<String, Object> deleteSpResult) {
        int code = (Integer)deleteSpResult.get("ErorrNum");
        String error = String.valueOf(deleteSpResult.get("Erorrtxt"));
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (code == 1817) {
            String fullError = String.format("\u062c\u0647\u062a \u0627\u06cc\u0646 \u0637\u0631\u0641 \u062d\u0633\u0627\u0628 %s \u062a\u0639\u0631\u06cc\u0641 \u0634\u062f\u0647 \u0648 \u0627\u0645\u06a9\u0627\u0646 \u062d\u0630\u0641 \u0622\u0646 \u0648\u062c\u0648\u062f \u0646\u062f\u0627\u0631\u062f.", error);
            result.put("ErrorCode", code);
            result.put("ErrorMessage", fullError);
        }
        return result;
    }

    private StringBuilder getInsertStatement(LoginDto myLogin) {
        StringBuilder sb = new StringBuilder();
        sb.append("Insert Into Customer(").append("C_Code, C_Code_C,C_Name, Kharid, Forosh, Vaseteh, Vaseteh_Porsant, Karshenas, InListSiah,").append("SelectType, City_Code, First_BalanceSanad,Sum_Takhfif, Etebar, NetHlp, Col_Code_Bed,").append("Moien_Code_Bed,Tafzili_Code_Bed,Col_Code_Bes, Moien_Code_Bes,Tafzili_Code_Bes,").append("ArzID,Money_price,CalledDate,Creation_date,National_Code,Economic_Code,C_Tel,C_Mobile,C_Fax,").append("cust_city, CityCodeLevy, Cust_Ostan, OstanCodeLevy, ").append("Cust_Mantagheh,Zip_Code,C_Address,Cust_Job,Birth_Date,Email_Address,WebId, C_type, IsSeller");
        if (!myLogin.getIsMyHoloo().booleanValue() && !myLogin.getIsTorfehNegar().booleanValue() && this.settingDao.getMSetup2Boolean(myLogin, "CustDefSmsGroup") && !this.settingDao.getMSetup2String(myLogin, "CustDefSmsGroup", "").isEmpty()) {
            sb.append(", SMSGroup");
        }
        if (!myLogin.getIsMyHoloo().booleanValue()) {
            sb.append(", latitude, longitude, UserCodeCust");
        }
        sb.append(", C_AliasName");
        if (!myLogin.getIsMyHoloo().booleanValue()) {
            sb.append(", National_Code_F, Personal_Code_F, Companey_Code_F, SellerWithTax, ExporterSId");
        }
        sb.append(")");
        return sb;
    }

    private void insertMidMan(CustomerDto customer, boolean isUpdate) {
        List erpCodeList;
        LoginDto login = this.dbConnection.setToken();
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(login);
        try {
            erpCodeList = customer.getCustomerVasetehDto().stream().map(e -> ConvertStr.decrypt((String)e.getErpcode())).collect(Collectors.toList());
        }
        catch (Exception e2) {
            throw new TncException(TncExceptionMessages.INVALID_MEDIATOR_ERP_CODE);
        }
        String sqlStr = "SELECT COUNT(*) cnt  FROM CUSTOMER  WHERE IsNull(vaseteh, 0) = 1 AND C_Code in(" + ConvertStr.getCommaSeparatedString(erpCodeList) + ")";
        SqlRowSet rs = jdbcTemplate.queryForRowSet(sqlStr);
        int cnt = 0;
        while (rs.next()) {
            cnt = rs.getInt("cnt");
        }
        if (cnt != erpCodeList.size()) {
            throw new TncException(TncExceptionMessages.INVALID_MEDIATOR_ERP_CODE);
        }
        if (isUpdate) {
            String cCode = ConvertStr.decrypt((String)customer.getErpcode());
            sqlStr = "SELECT Isnull(Vaseteh,0) IsVaseteh  FROM CUSTOMER \n  WHERE  C_Code =  " + cCode;
            SqlRowSet resSet = jdbcTemplate.queryForRowSet(sqlStr);
            boolean vaseteh = false;
            if (resSet.next()) {
                vaseteh = Boolean.parseBoolean(resSet.getString("IsVaseteh"));
            }
            if (vaseteh) {
                throw new TncException(TncExceptionMessages.INVALID_VASETEH_CUSTOMER);
            }
            jdbcTemplate.execute("DELETE FROM CustomerVaseteh WHERE C_Code = '" + customer.getId() + "'");
        }
        for (CustomerVasetehDto customerVasetehDto : customer.getCustomerVasetehDto()) {
            jdbcTemplate.update("INSERT INTO CustomerVaseteh(C_Code, Vaseteh_Code, Vaseteh_Porsant, Agent) \nVALUES(?, ?, ?,?)", new Object[]{customer.getId(), ConvertStr.decrypt((String)customerVasetehDto.getErpcode()), customerVasetehDto.getVasetehporsant(), customerVasetehDto.isAgent()});
        }
    }

    public void deleteMidMan(CustomerDto customer) {
        LoginDto login = this.dbConnection.setToken();
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(login);
        if (ConvertStr.isNullOrEmpty((String)customer.getErpcode())) {
            return;
        }
        jdbcTemplate.execute("DELETE FROM CustomerVaseteh WHERE C_Code = '" + customer.getId() + "'");
    }

    private void appendSelectStatement(StringBuilder sb, CustomerDto dto, LoginDto myLogin) {
        String webId = "0";
        if (!ConvertStr.isNullOrEmpty((String)dto.getInputid())) {
            webId = dto.getInputid();
        }
        sb.append(" ( ").append("'").append(dto.getId()).append("',").append("'").append(dto.getCode()).append("',").append("'").append(dto.getName()).append("',").append(ConvertStr.getBoolToInt((Boolean)dto.getIspurchaser())).append(",").append(ConvertStr.getBoolToInt((Boolean)dto.getIsseller())).append(",").append(ConvertStr.getBoolToInt((Boolean)dto.getIsvaseteh())).append(",").append(dto.getVasetehporsant()).append(",").append(0).append(",").append(ConvertStr.getBoolToInt((Boolean)dto.getIsblacklist())).append(",").append(dto.getSelecttype() == 0 ? 1 : dto.getSelecttype()).append(",").append(ConvertStr.parseNullSafeInt((String)dto.getCitycode()) == 0 ? Long.valueOf(1L) : dto.getCitycode()).append(",").append(0).append(",").append(0).append(",").append(dto.getCredit()).append(",").append(0).append(",").append("'").append(dto.getColCodeBed()).append("',").append("'").append(dto.getMoienCodeBed()).append("',").append("'").append(dto.getTafziliCodeBed()).append("',").append("'").append(dto.getColCodeBes()).append("',").append("'").append(dto.getMoienCodeBes()).append("',").append("'").append(dto.getTafziliCodeBes()).append("',").append(1).append(",").append(1).append(",").append("convert(nvarchar(10),GetDate(),111)").append(",").append("GetDate()").append(",").append("'").append(ConvertStr.nullSafeString((String)dto.getNationalid())).append("',").append("'").append(ConvertStr.nullSafeString((String)dto.getEconomicid())).append("',").append("'").append(ConvertStr.nullSafeString((String)dto.getTel())).append("',").append("'").append(ConvertStr.nullSafeString((String)dto.getMobile())).append("',").append("'").append(ConvertStr.nullSafeString((String)dto.getFax())).append("',").append("'").append(ConvertStr.nullSafeString((String)dto.getCity())).append("',").append("'").append(ConvertStr.nullSafeString((String)dto.getCitycodelevy())).append("',").append("'").append(ConvertStr.nullSafeString((String)dto.getOstan())).append("',").append("'").append(ConvertStr.nullSafeString((String)dto.getOstancode())).append("',").append("'").append(ConvertStr.nullSafeString((String)dto.getMantagheh())).append("',").append("'").append(ConvertStr.nullSafeString((String)dto.getZipcode())).append("',").append("'").append(ConvertStr.nullSafeString((String)dto.getAddress())).append("',").append("'").append(ConvertStr.nullSafeString((String)dto.getJob())).append("',").append("'").append(ConvertStr.nullSafeString((String)dto.getBirthdate())).append("',").append("'").append(ConvertStr.nullSafeString((String)dto.getEmail())).append("',").append(webId).append(",").append(dto.getType() == null ? 1 : dto.getType()).append(",").append(ConvertStr.getBoolToInt((Boolean)dto.getIsamer()));
        String smsGroup = this.settingDao.getMSetup2String(myLogin, "CustDefSmsGroup", "");
        if (!myLogin.getIsMyHoloo().booleanValue() && !myLogin.getIsTorfehNegar().booleanValue() && this.settingDao.getMSetup2Boolean(myLogin, "CustDefSmsGroup") && !smsGroup.isEmpty()) {
            sb.append(", '").append(StringUtilsKt.convertToDatabaseSmsGroup((String)smsGroup)).append("'");
        }
        if (!myLogin.getIsMyHoloo().booleanValue()) {
            sb.append(",").append(ConvertStr.toQuotedSql((Object)dto.getLatitude())).append(",").append(ConvertStr.toQuotedSql((Object)dto.getLongitude())).append(",").append(myLogin.getUserCodeInc());
        }
        sb.append(",").append(ConvertStr.toQuotedStrNotNullSql((String)dto.getNickname()));
        if (!myLogin.getIsMyHoloo().booleanValue()) {
            Integer exporterSId = myLogin.isAndroid() ? Integer.valueOf(4) : null;
            sb.append(",").append(ConvertStr.toQuotedSqlStr((String)dto.getNationalCodeF())).append(",").append(ConvertStr.toQuotedSqlStr((String)dto.getPersonalCodeF())).append(",").append(ConvertStr.toQuotedSqlStr((String)dto.getCompanyCodeF())).append(",").append(dto.getSellerwithtax()).append(",").append(exporterSId);
        }
        sb.append(" ) ");
    }

    private void appendUpdateStatement(StringBuilder sb, CustomerDto dto, boolean isMyHoloo) {
        sb.append("Update Customer Set WebId='").append(dto.getInputid()).append("'");
        if (dto.getCode() != null) {
            sb.append(" , C_Code_C = '").append(dto.getCode()).append("'");
        }
        if (dto.getName() != null) {
            sb.append(" , C_Name = '").append(dto.getName()).append("'");
        }
        if (dto.getIsblacklist() != null) {
            sb.append(", InListSiah=").append(ConvertStr.getBoolToInt((Boolean)dto.getIsblacklist()));
        }
        if (dto.getCredit() != null) {
            sb.append(", Etebar=").append(dto.getCredit());
        }
        if (dto.getNationalid() != null) {
            sb.append(", National_Code='").append(dto.getNationalid()).append("'");
        }
        if (dto.getEconomicid() != null) {
            sb.append(", Economic_Code='").append(dto.getEconomicid()).append("'");
        }
        if (dto.getTel() != null) {
            sb.append(", C_Tel='").append(dto.getTel()).append("'");
        }
        if (dto.getMobile() != null) {
            sb.append(", C_Mobile='").append(dto.getMobile()).append("'");
        }
        if (dto.getFax() != null) {
            sb.append(", C_Fax='").append(dto.getFax()).append("'");
        }
        if (dto.getCity() != null) {
            sb.append(", cust_city='").append(dto.getCity()).append("'");
        }
        if (dto.getCitycode() != null) {
            sb.append(", CityCodeLevy='").append(dto.getCitycode()).append("'");
        }
        if (ConvertStr.parseNullSafeInt((String)dto.getCitycode()) != 0) {
            sb.append(", city_code=").append(dto.getCitycode());
        }
        if (dto.getOstan() != null) {
            sb.append(", Cust_Ostan='").append(dto.getOstan()).append("'");
        }
        if (dto.getOstancode() != null) {
            sb.append(", OstanCodeLevy='").append(dto.getOstancode()).append("'");
        }
        if (dto.getMantagheh() != null) {
            sb.append(", Cust_Mantagheh='").append(dto.getMantagheh()).append("'");
        }
        if (dto.getZipcode() != null) {
            sb.append(", Zip_Code ='").append(dto.getZipcode()).append("'");
        }
        if (dto.getAddress() != null) {
            sb.append(", C_Address ='").append(dto.getAddress()).append("'");
        }
        if (dto.getJob() != null) {
            sb.append(", Cust_Job ='").append(dto.getJob()).append("'");
        }
        if (dto.getBirthdate() != null) {
            sb.append(", Birth_Date ='").append(dto.getBirthdate()).append("'");
        }
        if (dto.getEmail() != null) {
            sb.append(", Email_Address ='").append(dto.getEmail()).append("'");
        }
        if (dto.getIspurchaser() != null) {
            sb.append(", Kharid =").append(ConvertStr.getBoolToInt((Boolean)dto.getIspurchaser()));
        }
        if (dto.getIsseller() != null) {
            sb.append(", Forosh =").append(ConvertStr.getBoolToInt((Boolean)dto.getIsseller()));
        }
        if (dto.getType() != null) {
            sb.append(", C_TYPE = '").append(dto.getType()).append("'");
        }
        if (dto.getIsamer() != null) {
            sb.append(", IsSeller = '").append(ConvertStr.getBoolToInt((Boolean)dto.getIsamer())).append("'");
        }
        if (dto.getNationalCodeF() != null) {
            sb.append(", National_Code_F = '").append(dto.getNationalCodeF()).append("'");
        }
        if (dto.getPersonalCodeF() != null) {
            sb.append(", Personal_Code_F = '").append(dto.getPersonalCodeF()).append("'");
        }
        if (dto.getCompanyCodeF() != null) {
            sb.append(", Companey_Code_F = '").append(dto.getCompanyCodeF()).append("'");
        }
        if (!isMyHoloo && dto.getLatitude() != null) {
            sb.append(", latitude = ").append(dto.getLatitude());
        }
        if (!isMyHoloo && dto.getLongitude() != null) {
            sb.append(", longitude = ").append(dto.getLongitude());
        }
        if (dto.getNickname() != null) {
            sb.append(", C_AliasName = ").append(ConvertStr.toQuotedSql((Object)dto.getNickname()));
        }
        if (dto.getSelecttype() != 1) {
            sb.append(", SelectType='").append(dto.getSelecttype()).append("'");
        }
        sb.append(" Where C_Code='").append(dto.getId()).append("'");
    }

    public synchronized ResponseEntity<Map<String, Object>> postCustomerList(CustomerPostOptions options) {
        CustomerDto[] customerDtoArray;
        ArrayList<Map> failure = new ArrayList<Map>();
        ArrayList success = new ArrayList();
        LoginDto myLogin = this.dbConnection.setToken();
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(myLogin);
        try {
            customerDtoArray = this.getCustomerDtoArray(options);
        }
        catch (Exception ex) {
            TncException e = new TncException(TncExceptionMessages.WRONG_JSON_STRUCT);
            if (myLogin.getIsTorfehNegar().booleanValue()) {
                e.putMoreInfo("ErrorMessage", (Object)ex.getMessage());
            }
            failure.add(e.getErrorMap());
            return ConvertStr.getMapResponseEntity((String)"Customer", failure, success);
        }
        if (myLogin.getIsMyHoloo().booleanValue() && customerDtoArray.length > 0 && !ConvertStr.isNullOrEmpty((String)customerDtoArray[0].getC_code())) {
            return this.postCustomerListOnly(myLogin, customerDtoArray, options.isUpdate());
        }
        StringBuilder sb = new StringBuilder();
        for (CustomerDto customerDto : customerDtoArray) {
            SqlRowSet rowSet;
            String sqlStr;
            customerDto.setInputid(customerDto.getId());
            try {
                String duplicateCodeC;
                if (!(myLogin.getIsTorfehNegar().booleanValue() || myLogin.isAndroid() || options.isUpdate())) {
                    this.checkWebId(customerDto.getId(), (JdbcTemplate)jdbcTemplate);
                }
                if (customerDto.getCusttype() == 0 || customerDto.getCusttype() == 2) {
                    if (ConvertStr.isNullOrEmpty((String)customerDto.getBedsarfasl())) {
                        customerDto.setBedsarfasl("103");
                    }
                } else {
                    customerDto.setBedsarfasl("");
                }
                if (customerDto.getCusttype() == 1 || customerDto.getCusttype() == 2) {
                    if (ConvertStr.isNullOrEmpty((String)customerDto.getBessarfasl())) {
                        customerDto.setBessarfasl("401");
                    }
                } else {
                    customerDto.setBessarfasl("");
                }
                if (!ConvertStr.isNullOrEmpty((String)customerDto.getZipcode()) && ConvertStr.nullSafeString((String)customerDto.getZipcode()).length() > 10) {
                    throw new TncException(TncExceptionMessages.INVALID_POSTAL_CODE);
                }
                if (myLogin.getIsTorfehNegar().booleanValue() && ConvertStr.isNullOrEmpty((String)customerDto.getZipcode())) {
                    customerDto.setZipcode("2222222222");
                }
                customerDto.setId(ConvertStr.decrypt((String)ConvertStr.getNullIfEmpty((String)customerDto.getErpcode())));
                if (customerDto.getSelecttype() > 10) {
                    throw new TncException(TncExceptionMessages.INVALID_SELECT_TYPE);
                }
                if (!ConvertStr.isNullOrEmpty((String)customerDto.getCode())) {
                    if (customerDto.getCode().length() > 12) {
                        throw new TncException(TncExceptionMessages.INVALID_CUSTOMER_CODE);
                    }
                    if (myLogin.getIsMyHoloo().booleanValue() && !options.isUpdate() && this.getCountByCodeC((JdbcTemplate)jdbcTemplate, customerDto.getCode()) > 0) {
                        throw new TncException(TncExceptionMessages.DUPLICATE_CUSTOMER_CODE);
                    }
                }
                if (!options.isUpdate() && ConvertStr.isNullOrEmpty((String)customerDto.getName())) {
                    throw new TncException(TncExceptionMessages.INVALID_CUSTOMER_NAME);
                }
                if (myLogin.getIsMyHoloo().booleanValue() && (duplicateCodeC = this.getDuplicateCodeCByName((JdbcTemplate)jdbcTemplate, customerDto.getName())) != null) {
                    throw new TncException(TncExceptionMessages.DUPLICATE_CUSTOMER_NAME.setArgs(new Object[]{duplicateCodeC}));
                }
                if (customerDto.getType() != null && (customerDto.getType() < 1 || customerDto.getType() > 3)) {
                    throw new TncException(TncExceptionMessages.INVALID_CUSTOMER_LEGAL_TYPE);
                }
                if (!ConvertStr.isNullOrEmpty((String)customerDto.getBirthdate())) {
                    if (customerDto.getBirthdate().length() != 10) {
                        throw new TncException(TncExceptionMessages.INVALID_DATE);
                    }
                    customerDto.setBirthdate(customerDto.getBirthdate().replace("/", ".").replace("-", "."));
                }
                if (!options.isAllowDuplicateCell() && !ConvertStr.isNullOrEmpty((String)customerDto.getMobile())) {
                    sqlStr = "Select Count(*)cnt From Customer where C_Code<>'" + customerDto.getId() + "' And C_mobile='" + customerDto.getMobile() + "'";
                    rowSet = jdbcTemplate.queryForRowSet(sqlStr);
                    while (rowSet.next()) {
                        if (rowSet.getInt("cnt") <= 0) continue;
                        throw new TncException(TncExceptionMessages.DUPLICATE_MOBILE_NUM);
                    }
                }
                if (!options.isAllowDuplicateNatCode() && !ConvertStr.isNullOrEmpty((String)customerDto.getNationalid())) {
                    sqlStr = "Select Count(*)cnt From Customer where C_Code<>'" + customerDto.getId() + "' And National_Code='" + customerDto.getNationalid() + "'";
                    rowSet = jdbcTemplate.queryForRowSet(sqlStr);
                    while (rowSet.next()) {
                        if (rowSet.getInt("cnt") <= 0) continue;
                        throw new TncException(TncExceptionMessages.DUPLICATE_NATIONAL_CODE);
                    }
                }
                if (!options.isAllowDuplicateEcoCode() && !ConvertStr.isNullOrEmpty((String)customerDto.getEconomicid())) {
                    sqlStr = "Select Count(*)cnt From Customer where C_Code<>'" + customerDto.getId() + "' And Economic_Code='" + customerDto.getEconomicid() + "'";
                    rowSet = jdbcTemplate.queryForRowSet(sqlStr);
                    while (rowSet.next()) {
                        if (rowSet.getInt("cnt") <= 0) continue;
                        throw new TncException(TncExceptionMessages.DUPLICATE_ECONOMIC_CODE);
                    }
                }
                if (!ConvertStr.isNullOrEmpty((Collection)customerDto.getMoreAddress())) {
                    if (customerDto.getMoreAddress().size() > 5) {
                        throw new TncException(TncExceptionMessages.ADDRESS_COUNT_MORE_THAN_FIVE);
                    }
                    if (!options.isUpdate() && ConvertStr.isNullOrEmpty((String)customerDto.getAddress())) {
                        throw new TncException(TncExceptionMessages.CANNOT_USE_MORE_ADDRESS_WITHOUT_ADDRESS);
                    }
                    if (!options.isUpdate() && customerDto.invalidAddressTitlesInsert() || options.isUpdate() && customerDto.invalidAddressTitlesUpdate()) {
                        throw new TncException(TncExceptionMessages.INVALID_ADDRESS_TITLES);
                    }
                    if (options.isUpdate() && customerDto.invalidIds()) {
                        throw new TncException(TncExceptionMessages.INVALID_ADDRESS_IDS);
                    }
                    if (options.isUpdate() && this.givenAddressIdMakesGaps((JdbcTemplate)jdbcTemplate, customerDto)) {
                        throw new TncException(TncExceptionMessages.GAP_BETWEEN_ADDRESS_IDS);
                    }
                }
                if (options.isUpdate()) {
                    if (ConvertStr.isNullOrEmpty((String)customerDto.getCCode())) {
                        customerDto.setId(ConvertStr.decrypt((String)ConvertStr.getNullIfEmpty((String)customerDto.getErpcode())));
                    } else {
                        customerDto.setId(customerDto.getCCode());
                    }
                    sqlStr = "Select Count(*)cnt From Customer where C_Code='" + customerDto.getId() + "'";
                    rowSet = jdbcTemplate.queryForRowSet(sqlStr);
                    while (rowSet.next()) {
                        if (rowSet.getInt("cnt") != 0) continue;
                        throw new TncException(TncExceptionMessages.INVALID_CUSTOMER_ERP_CODE);
                    }
                    if (customerDto.getIspurchaser() != null && !customerDto.getIspurchaser().booleanValue()) {
                        sqlStr = "SELECT COUNT(Fac_Code) cnt FROM FACTURE   WHERE (C_Code = '" + customerDto.getId() + "') AND (Fac_Type IN ('F' ,'Y' )) And C_Code in (Select C_Code from Customer where C_Code='" + customerDto.getId() + "' And Kharid=1 )";
                        rowSet = jdbcTemplate.queryForRowSet(sqlStr);
                        while (rowSet.next()) {
                            if (rowSet.getInt("cnt") <= 0) continue;
                            throw new TncException(TncExceptionMessages.CANNOT_REMOVE_FROM_SELLERS_SALE_INVOICE_ALREADY_EXISTS);
                        }
                    }
                    if (customerDto.getIsseller() != null && !customerDto.getIsseller().booleanValue()) {
                        sqlStr = "SELECT COUNT(Fac_Code)cnt  FROM FACTURE   WHERE (C_Code = '" + customerDto.getId() + "') AND (Fac_Type IN ('K' ,'X' )) And C_Code in (Select C_Code from Customer where C_Code='" + customerDto.getId() + "' And Forosh=1 )";
                        rowSet = jdbcTemplate.queryForRowSet(sqlStr);
                        while (rowSet.next()) {
                            if (rowSet.getInt("cnt") <= 0) continue;
                            throw new TncException(TncExceptionMessages.CANNOT_REMOVE_FROM_BUYERS_BUY_INVOICE_ALREADY_EXISTS);
                        }
                    }
                    if (!myLogin.getIsMyHoloo().booleanValue()) {
                        sqlStr = " SELECT C_NAME FROM CUSTOMER WHERE C_CODE='" + customerDto.getId() + "'";
                        rowSet = jdbcTemplate.queryForRowSet(sqlStr);
                        String oldName = customerDto.getName();
                        if (rowSet.next()) {
                            oldName = rowSet.getString("C_NAME");
                        }
                        assert (oldName != null);
                        if (!ConvertStr.isNullOrEmpty((String)customerDto.getName()) && !oldName.equals(customerDto.getName())) {
                            sqlStr = " UPDATE SARFASL SET SARFASL_NAME ='" + customerDto.getName() + "' WHERE COMMON ='" + customerDto.getId() + "'";
                            jdbcTemplate.execute(sqlStr);
                            sqlStr = " UPDATE SND_LIST SET COMMENT_LINE = REPLACE(COMMENT_LINE, ?, ?) WHERE COMMENT_LINE LIKE '%" + oldName + "%' AND SANAD_CODE  IN (SELECT DISTINCT SANAD_CODE FROM SND_LIST  WHERE COL_CODE + MOIEN_CODE + TAFZILI_CODE  IN (SELECT COL_CODE + MOIEN_CODE + TAFZILI_CODE FROM SARFASL WHERE COMMON = ?))";
                            jdbcTemplate.update(sqlStr, new Object[]{oldName, customerDto.getName(), customerDto.getId()});
                        }
                    }
                } else {
                    if (ConvertStr.isNullOrEmpty((String)customerDto.getName())) {
                        throw new TncException(TncExceptionMessages.PARTY_NAME_EMPTY);
                    }
                    String oldBedSarfasl = customerDto.getBedsarfasl();
                    String oldBesSarfasl = customerDto.getBessarfasl();
                    if (!ConvertStr.isNullOrEmpty((String)customerDto.getBedsarfasl())) {
                        customerDto.setBedsarfasl(this.getColCodeCustomerBedBes(myLogin, false, customerDto.getBedsarfasl()));
                    }
                    if (!ConvertStr.isNullOrEmpty((String)customerDto.getBessarfasl())) {
                        customerDto.setBessarfasl(this.getColCodeCustomerBedBes(myLogin, true, customerDto.getBessarfasl()));
                    }
                    if (myLogin.getIsMyHoloo().booleanValue() && this.invalidAccountCode(customerDto, oldBedSarfasl, oldBesSarfasl)) {
                        throw new TncException(TncExceptionMessages.INVALID_ACCOUNT_CODE);
                    }
                    if (!myLogin.getIsMyHoloo().booleanValue() && !ConvertStr.isNullOrEmpty((String)customerDto.getBedsarfasl())) {
                        if (customerDto.getBedsarfasl().length() == 3) {
                            throw new TncException(TncExceptionMessages.INVALID_ACCOUNT_CODE);
                        }
                        sqlStr = "Select Count(*) cnt From Sarfasl Where Sarfasl_Code='" + customerDto.getBedsarfasl() + "'";
                        rowSet = jdbcTemplate.queryForRowSet(sqlStr);
                        while (rowSet.next()) {
                            if (rowSet.getInt("cnt") <= 0) continue;
                            throw new TncException(TncExceptionMessages.DUPLICATE_ACCOUNT_CODE);
                        }
                    }
                    if (!myLogin.getIsMyHoloo().booleanValue() && !ConvertStr.isNullOrEmpty((String)customerDto.getBessarfasl())) {
                        if (customerDto.getBessarfasl().length() == 3) {
                            throw new TncException(TncExceptionMessages.INVALID_ACCOUNT_CODE);
                        }
                        sqlStr = "Select Count(*) cnt From Sarfasl Where Sarfasl_Code='" + customerDto.getBessarfasl() + "'";
                        rowSet = jdbcTemplate.queryForRowSet(sqlStr);
                        while (rowSet.next()) {
                            if (rowSet.getInt("cnt") <= 0) continue;
                            throw new TncException(TncExceptionMessages.DUPLICATE_ACCOUNT_CODE);
                        }
                    }
                    if (!myLogin.getIsTorfehNegar().booleanValue()) {
                        sqlStr = "Select Max(C_Code) + 1 C_Code From Customer";
                        rowSet = jdbcTemplate.queryForRowSet(sqlStr);
                        customerDto.setId("");
                        while (rowSet.next()) {
                            customerDto.setId(ConvertStr.getNullIfEmpty((String)rowSet.getString("C_Code")));
                        }
                        customerDto.setId(ConvertStr.produceCode((int)Integer.parseInt(customerDto.getId()), (int)5));
                    } else {
                        sqlStr = "Select Max(C_Code) C_Code From Customer";
                        rowSet = jdbcTemplate.queryForRowSet(sqlStr);
                        customerDto.setId("");
                        while (rowSet.next()) {
                            customerDto.setId(ConvertStr.getNullIfEmpty((String)rowSet.getString("C_Code")));
                        }
                        if (customerDto.getId().matches("[0-9]+") && Integer.parseInt(customerDto.getId()) + 1 <= 99999) {
                            customerDto.setId(ConvertStr.produceCode((int)(Integer.parseInt(customerDto.getId()) + 1), (int)5));
                        } else {
                            sqlStr = "select dbo.udf_max_char_code(MAX(C_CODE)) [C_CODE] from Customer";
                            rowSet = jdbcTemplate.queryForRowSet(sqlStr);
                            while (rowSet.next()) {
                                customerDto.setId(rowSet.getString("C_CODE"));
                            }
                        }
                    }
                    if (ConvertStr.isNullOrEmpty((String)customerDto.getCode())) {
                        customerDto.setCode(customerDto.getId());
                        boolean findMaxCode = false;
                        while (!findMaxCode) {
                            sqlStr = "Select Count(*) cnt  From Customer Where C_Code_C='" + customerDto.getCode() + "'";
                            rowSet = jdbcTemplate.queryForRowSet(sqlStr);
                            while (rowSet.next()) {
                                if (rowSet.getInt("cnt") > 0) {
                                    customerDto.setCode(ConvertStr.produceCode((int)(Integer.parseInt(customerDto.getCode()) + 1), (int)5));
                                    continue;
                                }
                                findMaxCode = true;
                            }
                        }
                    }
                    if (ConvertStr.isNullOrEmpty((String)customerDto.getBedsarfasl()) && ConvertStr.isNullOrEmpty((String)customerDto.getBessarfasl())) {
                        throw new TncException(TncExceptionMessages.NO_CUSTOMER_ACCOUNT_TYPE);
                    }
                    if (!myLogin.getIsMyHoloo().booleanValue()) {
                        if (!ConvertStr.isNullOrEmpty((String)customerDto.getBedsarfasl())) {
                            this.insertSarfasl((JdbcTemplate)jdbcTemplate, 0, customerDto);
                        }
                        if (!ConvertStr.isNullOrEmpty((String)customerDto.getBessarfasl())) {
                            this.insertSarfasl((JdbcTemplate)jdbcTemplate, 1, customerDto);
                        }
                    }
                }
                sb.delete(0, sb.length());
                if (options.isUpdate()) {
                    customerDto.rearrangeAddressIds((JdbcTemplate)jdbcTemplate);
                    this.appendUpdateStatement(sb, customerDto, myLogin.getIsMyHoloo().booleanValue());
                    if (customerDto.getCustomerVasetehDto() != null) {
                        if (customerDto.getCustomerVasetehDto().isEmpty()) {
                            this.deleteMidMan(customerDto);
                        } else {
                            this.insertMidMan(customerDto, true);
                        }
                    }
                    customerDto.setCode("");
                    customerDto.setBedsarfasl("");
                    customerDto.setBessarfasl("");
                    sb.append(customerDto.getUpdateAddressesSql());
                } else {
                    if (customerDto.getCustomerVasetehDto() != null && customerDto.getCustomerVasetehDto().size() > 0) {
                        if (customerDto.getIsvaseteh().equals(true)) {
                            throw new TncException(TncExceptionMessages.INVALID_VASETEH_CUSTOMER);
                        }
                        this.insertMidMan(customerDto, false);
                    }
                    sb = this.getInsertStatement(myLogin);
                    sb.append("values ");
                    this.appendSelectStatement(sb, customerDto, myLogin);
                    sb.append(customerDto.getInsertAddressesSql());
                }
                StringBuilder finalSb = sb;
                Boolean successful = (Boolean)this.dbConnection.getTransactionTemplate(myLogin).execute(arg_0 -> CustomerDao.lambda$postCustomerList$2((JdbcTemplate)jdbcTemplate, finalSb, failure, arg_0));
                if (!ConvertStr.nullSafeBool((Boolean)successful)) continue;
                LinkedHashMap<String, Object> model = new LinkedHashMap<String, Object>();
                if (!ConvertStr.isNullOrEmpty((String)customerDto.getInputid())) {
                    model.put("Id", customerDto.getInputid());
                }
                model.put("ErpCode", ConvertStr.encrypt((String)customerDto.getId()));
                if (!ConvertStr.isNullOrEmpty((String)customerDto.getCode())) {
                    model.put("Code", customerDto.getCode());
                }
                if (!ConvertStr.isNullOrEmpty((String)customerDto.getBedsarfasl())) {
                    model.put("BedSarfasl", customerDto.getBedsarfasl());
                }
                if (!ConvertStr.isNullOrEmpty((String)customerDto.getBessarfasl())) {
                    model.put("BesSarfasl", customerDto.getBessarfasl());
                }
                if (myLogin.getIsMyHoloo().booleanValue()) {
                    model.put("Dbname", myLogin.getDatabaseName().substring(myLogin.getDatabaseName().indexOf("[") + 1, myLogin.getDatabaseName().lastIndexOf("]")));
                }
                model.put("addresses", customerDto.getAllGivenAddresses());
                success.add(model);
                CustomerProcessDao customerProcessDao = new CustomerProcessDao(this.dbConnection, myLogin, JsonDeserializer.toJson((Object)customerDto));
                if (CustomerPostOptions.access$000((CustomerPostOptions)options)) {
                    customerProcessDao.insert((Object)customerDto, ProcessDao.ProcessKind.EDIT);
                    continue;
                }
                customerProcessDao.insert((Object)customerDto, ProcessDao.ProcessKind.ADD);
            }
            catch (TncException e) {
                boolean isDuplicateDataError;
                if (!ConvertStr.isNullOrEmpty((String)customerDto.getInputid())) {
                    e.putMoreInfo("Id", (Object)customerDto.getInputid());
                }
                boolean bl = isDuplicateDataError = e.getErrorCode() == 10 || e.getErrorCode() == 23 || e.getErrorCode() == 24 || e.getErrorCode() == 12;
                if (isDuplicateDataError) {
                    sqlStr = "SELECT TOP 1 C_CODE, NATIONAL_CODE FROM CUSTOMER WHERE C_CODE <> ? AND (C_MOBILE = ?  OR NATIONAL_CODE = ? OR ECONOMIC_CODE= ?)";
                    rowSet = jdbcTemplate.queryForRowSet(sqlStr, new Object[]{customerDto.getId(), customerDto.getMobile(), customerDto.getNationalid(), customerDto.getEconomicid()});
                    while (rowSet.next()) {
                        String cCode = rowSet.getString("C_CODE");
                        String nCode = rowSet.getString("NATIONAL_CODE");
                        if (cCode != null && !cCode.isEmpty()) {
                            e.putMoreInfo("ExistingCustomerErpCode", (Object)ConvertStr.encrypt((String)cCode));
                        }
                        if (!myLogin.getIsTorfehNegar().booleanValue() || nCode == null) continue;
                        e.putMoreInfo("NationalCode", (Object)nCode);
                    }
                }
                if (e.getException().equals((Object)TncExceptionMessages.DUPLICATE_CUSTOMER_NAME) && !ConvertStr.isNullOrEmpty((Collection)e.getException().getArgs())) {
                    e.putMoreInfo("code", e.getException().getArgs().get(0));
                }
                if (myLogin.getIsMyHoloo().booleanValue()) {
                    e.putMoreInfo("Dbname", (Object)myLogin.getDatabaseName().substring(myLogin.getDatabaseName().indexOf("[") + 1, myLogin.getDatabaseName().lastIndexOf("]")));
                }
                failure.add(e.getErrorMap());
            }
        }
        return ConvertStr.getMapResponseEntity((String)"Customer", failure, success);
    }

    private CustomerDto[] getCustomerDtoArray(CustomerPostOptions options) throws JSONException {
        if (options.getCustomerDtoArray() != null) {
            return options.getCustomerDtoArray();
        }
        String body = options.getBody();
        if (options.isRebuildJson()) {
            JSONObject obj = new JSONObject(body);
            obj = ConvertStr.rebuildJsonObject((JSONObject)obj);
            JSONArray jsonArray = obj.getJSONArray("custinfo");
            body = jsonArray.toString();
        } else {
            body = body.substring(12, body.length() - 1);
        }
        return (CustomerDto[])new Gson().fromJson(body, CustomerDto[].class);
    }

    private boolean givenAddressIdMakesGaps(JdbcTemplate jdbcTemplate, CustomerDto customerDto) {
        SqlRowSet rs = jdbcTemplate.queryForRowSet("SELECT C_ADDRESS '1', C_ADDRESS1 '2', C_ADDRESS2 '3', \n C_ADDRESS3 '4', C_ADDRESS4 '5', C_ADDRESS5 '6' \n FROM CUST_TELL \n INNER JOIN CUSTOMER ON CCode = C_CODE \n WHERE CCode = ?", new Object[]{customerDto.getId()});
        if (!rs.next()) {
            return false;
        }
        for (CustomerAddressDto address : customerDto.getMoreAddress()) {
            for (String lesserId : address.getLesserIds()) {
                if (!ConvertStr.isNullOrEmpty((String)rs.getString(lesserId))) continue;
                return true;
            }
        }
        return false;
    }

    private void checkWebId(String webId, JdbcTemplate jdbcTemplate) throws TncException {
        if (webId == null) {
            throw new TncException(TncExceptionMessages.INVALID_ID);
        }
        String sql = "SELECT COUNT(*) FROM CUSTOMER WHERE WebId = '" + webId + "'";
        Integer webIdCount = (Integer)jdbcTemplate.queryForObject(sql, Integer.class);
        if (webIdCount != null && webIdCount > 0) {
            throw new TncException(TncExceptionMessages.DUPLICATE_WEB_ID);
        }
    }

    private int getCountByCodeC(JdbcTemplate jdbcTemplate, String code) {
        SqlRowSet rs = jdbcTemplate.queryForRowSet(" SELECT COUNT(*) CNT FROM CUSTOMER WHERE C_CODE_C = ?", new Object[]{code});
        if (rs.next()) {
            return rs.getInt("CNT");
        }
        return 0;
    }

    private String getDuplicateCodeCByName(JdbcTemplate jdbcTemplate, String name) {
        SqlRowSet rs = jdbcTemplate.queryForRowSet(" SELECT C_CODE_C FROM CUSTOMER WHERE C_NAME = ?", new Object[]{name});
        if (rs.next()) {
            return rs.getString("C_CODE_C");
        }
        return null;
    }

    private boolean invalidAccountCode(CustomerDto customerDto, String oldBedSarfasl, String oldBesSarfasl) {
        return ConvertStr.isNullOrEmpty((String)customerDto.getBedsarfasl()) && ConvertStr.isNullOrEmpty((String)customerDto.getBessarfasl()) || !ConvertStr.isNullOrEmpty((String)oldBedSarfasl) && customerDto.getBedsarfasl().isEmpty() || !ConvertStr.isNullOrEmpty((String)oldBesSarfasl) && customerDto.getBessarfasl().isEmpty();
    }

    private void insertSarfasl(JdbcTemplate jdbcTemplate, int bedBesType, CustomerDto customer) {
        String sarfaslCode;
        int groupSarfasl = 1;
        int mahiatSarfasl = 1;
        String sqlStr = bedBesType == 0 ? "Select [Group] GP,[Mahiat] MA From Sarfasl Where Sarfasl_Code='" + customer.getColCodeBed() + "'" : "Select [Group] GP,[Mahiat] MA From Sarfasl Where Sarfasl_Code='" + customer.getColCodeBes() + "'";
        SqlRowSet rowSet = jdbcTemplate.queryForRowSet(sqlStr);
        while (rowSet.next()) {
            groupSarfasl = rowSet.getInt("GP");
            mahiatSarfasl = rowSet.getInt("MA");
        }
        sqlStr = bedBesType == 0 ? "select Id from sarfasltype where DefaultSarfasl='" + customer.getColCodeBed() + "'" : "select Id from sarfasltype where DefaultSarfasl='" + customer.getColCodeBes() + "'";
        rowSet = jdbcTemplate.queryForRowSet(sqlStr);
        int sType = 5;
        while (rowSet.next()) {
            sType = rowSet.getInt("Id");
        }
        if (bedBesType == 0) {
            sarfaslCode = customer.getColCodeBed();
            if (!ConvertStr.isNullOrEmpty((String)customer.getTafziliCodeBed())) {
                sarfaslCode = customer.getColCodeBed() + customer.getMoienCodeBed();
            }
        } else {
            sarfaslCode = customer.getColCodeBes();
            if (!ConvertStr.isNullOrEmpty((String)customer.getTafziliCodeBes())) {
                sarfaslCode = customer.getColCodeBes() + customer.getMoienCodeBes();
            }
        }
        sqlStr = "select Id from Sarfasl where Sarfasl_Code='" + sarfaslCode + "'";
        rowSet = jdbcTemplate.queryForRowSet(sqlStr);
        int parent = 0;
        while (rowSet.next()) {
            parent = rowSet.getInt("Id");
        }
        sqlStr = "Insert Into Sarfasl(SarFasl_Name,Common,Col_Code,Moien_Code,Tafzili_Code,SarFasl_Code,[Group],Mahiat,Can_Delete,Type,Parent) Values('" + customer.getName() + "','" + customer.getId() + "',";
        sqlStr = bedBesType == 0 ? sqlStr + "'" + customer.getColCodeBed() + "','" + customer.getMoienCodeBed() + "','" + customer.getTafziliCodeBed() + "','" + customer.getBedsarfasl() + "'" : sqlStr + "'" + customer.getColCodeBes() + "','" + customer.getMoienCodeBes() + "','" + customer.getTafziliCodeBes() + "','" + customer.getBessarfasl() + "'";
        sqlStr = sqlStr + "," + groupSarfasl + "," + mahiatSarfasl + ",0," + sType + "," + parent + ")";
        jdbcTemplate.execute(sqlStr);
    }

    private String getColCodeCustomerBedBes(LoginDto myLogin, boolean isCreditor, String sarfaslCode) {
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(myLogin);
        String result = "";
        String colCode = sarfaslCode.substring(0, 3);
        String sqlStr = "SELECT Col_Code FROM Sarfasl WHERE Moien_code = '' AND ";
        sqlStr = !isCreditor ? sqlStr + " Type = 5" : sqlStr + " Type = 15";
        SqlRowSet rowSet = this.dbConnection.getJdbcTemplate(myLogin).queryForRowSet(sqlStr);
        while (rowSet.next()) {
            if (!colCode.equals(rowSet.getString("Col_Code"))) continue;
            result = rowSet.getString("Col_Code");
            break;
        }
        if (ConvertStr.isNullOrEmpty((String)result)) {
            result = !isCreditor ? "103" : "401";
        }
        colCode = result;
        String moienCode = "";
        if (sarfaslCode.length() > 6) {
            moienCode = sarfaslCode.substring(3, 7);
        }
        String tafsiliCode = "";
        if (sarfaslCode.length() > 7) {
            tafsiliCode = sarfaslCode.substring(7);
        }
        if (myLogin.getIsMyHoloo().booleanValue()) {
            sqlStr = "SELECT Count(*) cnt FROM Sarfasl  WHERE Moien_code <> '' AND ISNULL(Common,'') = '' AND  ";
            sqlStr = !isCreditor ? sqlStr + " Type = 5" : sqlStr + " Type = 15";
            rowSet = jdbcTemplate.queryForRowSet(sqlStr);
            int cnt = 0;
            while (rowSet.next()) {
                cnt = rowSet.getInt("cnt");
            }
            if (cnt == 0 || ConvertStr.isNullOrEmpty((String)moienCode)) {
                moienCode = "";
                tafsiliCode = "";
            } else {
                tafsiliCode = "";
                if (ConvertStr.isNullOrEmpty((String)moienCode)) {
                    colCode = "";
                } else {
                    sqlStr = "SELECT Count(*) cnt FROM Sarfasl  WHERE Sarfasl_Code = '" + colCode + moienCode + "' AND ISNULL(Common,'') = '' ";
                    rowSet = jdbcTemplate.queryForRowSet(sqlStr);
                    cnt = 0;
                    while (rowSet.next()) {
                        cnt = rowSet.getInt("cnt");
                    }
                    if (cnt == 0) {
                        colCode = "";
                        moienCode = "";
                    }
                }
            }
        } else {
            boolean freeCodeForCustomer = this.settingDao.getMSetup2Boolean(myLogin, "FreeCodeForCustomer");
            boolean customerBedMoienTafsili = this.settingDao.getMSetup2Boolean(myLogin, "BedCustomerMoienTaf");
            boolean customerBesMoienTafsili = this.settingDao.getMSetup2Boolean(myLogin, "BesCustomerMoienTaf");
            if (!freeCodeForCustomer || !isCreditor && customerBedMoienTafsili || isCreditor && customerBesMoienTafsili) {
                tafsiliCode = "";
                moienCode = this.getMaxSarfaslCode(jdbcTemplate, 0, colCode, moienCode, tafsiliCode);
            } else {
                tafsiliCode = this.getMaxSarfaslCode(jdbcTemplate, 1, colCode, moienCode = this.getMaxSarfaslCode(jdbcTemplate, 2, colCode, moienCode, ""), tafsiliCode);
                if (tafsiliCode.isEmpty()) {
                    moienCode = "";
                }
            }
            if (!freeCodeForCustomer && isCreditor) {
                colCode = "";
                moienCode = "";
                tafsiliCode = "";
            }
        }
        return colCode + moienCode + tafsiliCode;
    }

    private String getMaxSarfaslCode(TncJdbc jdbcTemplate, int sType, String colCode, String moienCode, String tafsiliCode) {
        boolean findNewCode;
        String newSarfaslCode = "";
        try {
            if (sType == 1) {
                newSarfaslCode = tafsiliCode;
                findNewCode = ConvertStr.isNullOrEmpty((String)tafsiliCode) || Integer.parseInt(tafsiliCode) < 0 || Integer.parseInt(tafsiliCode) > 9999;
            } else {
                newSarfaslCode = moienCode;
                findNewCode = ConvertStr.isNullOrEmpty((String)moienCode) || Integer.parseInt(moienCode) < 0 || Integer.parseInt(moienCode) > 9999;
            }
        }
        catch (NumberFormatException ex) {
            findNewCode = true;
        }
        if (findNewCode) {
            if (sType != 2) {
                String sqlStr = "SELECT MAX(Moien_Code) + 1 AS Max_CodeM, MAX(Tafzili_Code) + 1 AS Max_CodeT FROM dbo.SARFASL WHERE Col_Code = '" + colCode + "'";
                if (sType == 1) {
                    sqlStr = sqlStr + " AND Moien_Code ='" + moienCode + "' And MOIEN_CODE <> '' ";
                }
                SqlRowSet rowSet = jdbcTemplate.queryForRowSet(sqlStr);
                while (rowSet.next()) {
                    newSarfaslCode = sType == 0 ? rowSet.getString("Max_CodeM") : rowSet.getString("Max_CodeT");
                }
                try {
                    assert (newSarfaslCode != null);
                    int newSarfaslCodeInt = Integer.parseInt(newSarfaslCode);
                    if (newSarfaslCodeInt > 9999) {
                        String sarfaslToCheck = sType == 1 ? colCode + moienCode : colCode;
                        newSarfaslCodeInt = this.findSmallestGapInSarfasl(sType, sarfaslToCheck, jdbcTemplate);
                    }
                    newSarfaslCode = ConvertStr.produceCode((int)newSarfaslCodeInt, (int)4);
                }
                catch (NumberFormatException ex) {
                    newSarfaslCode = "";
                }
            } else {
                String sqlStr = "Select Moien_Code From SARFASL  where (Col_Code ='" + colCode + "') And (Moien_Code <> '')  And (Tafzili_Code = '') And ((Common is null) or (Common = ''))";
                String newMoienCode = "";
                SqlRowSet rowSet = jdbcTemplate.queryForRowSet(sqlStr);
                while (rowSet.next()) {
                    if (!newSarfaslCode.isEmpty() && !newSarfaslCode.equals(rowSet.getString("Moien_Code"))) continue;
                    newMoienCode = rowSet.getString("Moien_Code");
                    break;
                }
                newSarfaslCode = newMoienCode;
            }
        } else if (sType == 2) {
            String sqlStr = "Select Isnull(Common,'') Common From SARFASL  where (Sarfasl_code ='" + colCode + newSarfaslCode + "') ";
            SqlRowSet rowSet = jdbcTemplate.queryForRowSet(sqlStr);
            while (rowSet.next()) {
                if (ConvertStr.isNullOrEmpty((String)rowSet.getString("Common"))) continue;
                newSarfaslCode = "";
            }
        }
        return newSarfaslCode;
    }

    private int findSmallestGapInSarfasl(int sType, String sarfaslToCheck, TncJdbc tncJdbc) {
        String columnToFind = sType == 1 ? "Tafzili_Code" : "Moien_Code";
        String sql = "SELECT MIN (t1." + columnToFind + " + 1) AS FirstMissing\n  FROM SARFASL t1\n  WHERE NOT EXISTS (\n  SELECT 1 FROM SARFASL t2 \n  WHERE t2." + columnToFind + " = t1." + columnToFind + " + 1 AND " + (sType == 1 ? "t2.Col_Code + t2.Moien_Code" : "t2.Col_Code") + " = '" + sarfaslToCheck + "'\n  ) AND " + (sType == 1 ? "t1.Col_Code + t1.Moien_Code" : "t1.Col_Code") + " = '" + sarfaslToCheck + "'";
        SqlRowSet rs = tncJdbc.queryForRowSet(sql);
        if (rs.next()) {
            return rs.getInt("FirstMissing");
        }
        throw new TncException(TncExceptionMessages.REACHED_MAX_CUSTOMER_HEADING);
    }

    private ResponseEntity<Map<String, Object>> postCustomerListOnly(LoginDto myLogin, CustomerDto[] customerDtoArray, boolean isUpdate) {
        ArrayList<Map> failure = new ArrayList<Map>();
        ArrayList success = new ArrayList();
        try {
            this.insertOrDeleteCustomer(myLogin, customerDtoArray, isUpdate);
        }
        catch (Exception ex) {
            TncException exception = new TncException(TncExceptionMessages.DATA_INPUT_ERROR);
            failure.add(exception.makeErrorWithCause((Throwable)ex));
            return ConvertStr.getMapResponseEntity((String)"Customer", failure, success);
        }
        LinkedHashMap<String, Boolean> model = new LinkedHashMap<String, Boolean>();
        model.put("Success", true);
        success.add(model);
        return ConvertStr.getMapResponseEntity((String)"Customer", failure, success);
    }

    void insertOrDeleteCustomer(LoginDto myLogin, CustomerDto[] customerDtoArray, boolean isUpdate) {
        try {
            TransactionCheck.getInstance((DbConnection)this.dbConnection, (String)myLogin.getDatabaseName()).transactionDeadLockWrapper(() -> this.insertCustomer(myLogin, customerDtoArray, isUpdate), new String[0]);
        }
        catch (Exception ex) {
            this.deleteRepeatCustomer(myLogin, customerDtoArray);
            if (ConvertStr.exceptionContains((Exception)ex, (String)"duplicate key")) {
                this.insertOrDeleteCustomer(myLogin, customerDtoArray, isUpdate);
            }
            throw ex;
        }
    }

    private void insertCustomer(LoginDto myLogin, CustomerDto[] customerDtoArray, boolean isUpdate) {
        TncJdbc tncJdbc = this.dbConnection.getJdbcTemplate(myLogin);
        StringBuilder sb = new StringBuilder();
        MyHolooMessageMaker messageMaker = new MyHolooMessageMaker();
        int counter = 0;
        String insert = this.getInsertStatement(myLogin).append(" values ").toString();
        if (!isUpdate) {
            sb.append(insert);
        }
        for (CustomerDto customer : customerDtoArray) {
            if (isUpdate) {
                if (counter >= 50) {
                    tncJdbc.execute(sb.toString());
                    sb.delete(0, sb.length());
                    counter = 0;
                }
                customer.setId(customer.getC_code());
                this.appendUpdateStatement(sb, customer, myLogin.getIsMyHoloo().booleanValue());
            } else {
                counter = SideGroupDao.resetAndGetCounter((TncJdbc)tncJdbc, (StringBuilder)sb, (String)insert, (int)counter);
                customer.setId(customer.getC_code());
                this.appendSelectStatement(sb, customer, myLogin);
                sb.append(" , ");
                messageMaker.addIfAbsent(customer.getC_code(), customer.getIsupdate());
            }
            ++counter;
        }
        if (!isUpdate) {
            sb.deleteCharAt(sb.lastIndexOf(","));
        }
        tncJdbc.execute(sb.toString());
        CallApi.callApiGetNotify((LoginDto)myLogin, (String)"CUSTOMER", (int)(isUpdate ? 1 : 0), (String)messageMaker.makeCodes(), (String)messageMaker.makeMessage("\u0637\u0631\u0641 \u062d\u0633\u0627\u0628", isUpdate));
    }

    private void deleteRepeatCustomer(LoginDto myLogin, CustomerDto[] customerDtoArray) {
        TransactionCheck.getInstance((DbConnection)this.dbConnection, (String)myLogin.getDatabaseName()).transactionDeadLockWrapper(() -> {
            TncJdbc tncJdbc = this.dbConnection.getJdbcTemplate(myLogin);
            int i = 0;
            while (i < customerDtoArray.length) {
                StringBuilder cCode = new StringBuilder("'" + customerDtoArray[i].getC_code() + "'");
                ++i;
                for (int j = 0; j < 50 && i < customerDtoArray.length; ++j, ++i) {
                    cCode.append(",'").append(customerDtoArray[i].getC_code()).append("'");
                }
                tncJdbc.execute(" Delete Customer Where C_Code in (" + cCode + ")");
            }
        }, new String[]{"CUSTOMER"});
    }

    private String getFilter(HttpServletRequest request) {
        String sqlWhere = "";
        Map info = ConvertStr.rebuildQueryString((HttpServletRequest)request);
        if (info.containsKey("ispurchaser")) {
            sqlWhere = sqlWhere + " Isnull(C.Kharid,0)=" + ConvertStr.getBoolToInt((Boolean)Boolean.valueOf((String)info.get("ispurchaser")));
        }
        if (info.containsKey("isseller")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = sqlWhere + " Isnull(C.Forosh,0)=" + ConvertStr.getBoolToInt((Boolean)Boolean.valueOf((String)info.get("isseller")));
        }
        if (info.containsKey("isvaseteh")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = sqlWhere + " Isnull(C.Vaseteh,0)=" + ConvertStr.getBoolToInt((Boolean)Boolean.valueOf((String)info.get("isvaseteh")));
        }
        if (info.containsKey("code")) {
            String code = (String)info.get("code");
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            if (!code.contains(",")) {
                sqlWhere = sqlWhere + " Isnull(C.C_Code_C,'') = '" + code + "'";
            } else {
                code = code.replaceAll(",", "','");
                sqlWhere = sqlWhere + " Isnull(C.C_Code_C,'') in ('" + code + "')";
            }
        }
        if (info.containsKey("code.from")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = sqlWhere + " Isnull(C.C_Code_C,0) >= '" + (String)info.get("code.from") + "'";
        }
        if (info.containsKey("code.to")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = sqlWhere + " Isnull(C.C_Code_C,0) <= '" + (String)info.get("code.to") + "'";
        }
        if (info.containsKey("name")) {
            String name = (String)info.get("name");
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            if (!name.contains(",")) {
                sqlWhere = sqlWhere + " Isnull(C.C_Name,'') = '" + name + "'";
            } else {
                name = name.replaceAll(",", "','");
                sqlWhere = sqlWhere + " Isnull(C.C_Name,'') in ('" + name + "')";
            }
        }
        if (info.containsKey("date.from")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = sqlWhere + " C.ModifyDate >= '" + (String)info.get("date.from") + "'";
        }
        if (info.containsKey("date.to")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = sqlWhere + " C.ModifyDate <= '" + (String)info.get("date.to") + "'";
        }
        if (info.containsKey("cdate.from")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = sqlWhere + " C.Creation_Date >= '" + (String)info.get("cdate.from") + "'";
        }
        if (info.containsKey("cdate.to")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = sqlWhere + " C.Creation_Date <= '" + (String)info.get("cdate.to") + "'";
        }
        if (info.containsKey("bedsarfasl")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = sqlWhere + " C.Col_Code_Bed+C.Moien_Code_Bed+C.Tafzili_Code_Bed = '" + (String)info.get("bedsarfasl") + "'";
        }
        if (info.containsKey("bessarfasl")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = sqlWhere + " C.Col_Code_Bes+C.Moien_Code_Bes+C.Tafzili_Code_Bes = '" + (String)info.get("bessarfasl") + "'";
        }
        if (info.containsKey("mobile")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = sqlWhere + " Isnull(C.C_Mobile,0) = '" + (String)info.get("mobile") + "'";
        }
        if (info.containsKey("webid")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = sqlWhere + " Isnull(C.webid,0) = " + (String)info.get("webid");
        }
        if (info.containsKey("webid.from")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = sqlWhere + " Isnull(C.webid,0) >= " + (String)info.get("webid.from");
        }
        if (info.containsKey("webid.to")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = sqlWhere + " Isnull(C.webid,0) <= " + (String)info.get("webid.to");
        }
        if (info.containsKey("nationalid")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = sqlWhere + " Isnull(C.National_Code,0) = '" + (String)info.get("nationalid") + "'";
        }
        if (info.containsKey("isamer")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = sqlWhere + " Isnull(C.isSeller, 0) = " + (String)info.get("isamer");
        }
        if (info.containsKey("erpcode")) {
            String erpCode;
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            if (!(erpCode = (String)info.get("erpcode")).contains(",")) {
                sqlWhere = sqlWhere + " C.C_Code = '" + ConvertStr.decrypt((String)ConvertStr.getNullIfEmpty((String)erpCode)) + "'";
            } else {
                StringBuilder newerpcode = new StringBuilder();
                StringBuilder tmperpcode = new StringBuilder();
                for (int i = 0; i < erpCode.length(); ++i) {
                    if (erpCode.charAt(i) != ',') {
                        tmperpcode.append(erpCode, i, i + 1);
                        continue;
                    }
                    if (!sqlWhere.isEmpty()) {
                        newerpcode.append(",");
                    }
                    newerpcode.append("'").append(ConvertStr.decrypt((String)ConvertStr.getNullIfEmpty((String)tmperpcode.toString()))).append("'");
                    tmperpcode = new StringBuilder();
                }
                if (!"".contentEquals(tmperpcode)) {
                    newerpcode.append(",'").append(ConvertStr.decrypt((String)ConvertStr.getNullIfEmpty((String)tmperpcode.toString()))).append("'");
                }
                sqlWhere = sqlWhere + " C.C_Code in (" + newerpcode + ")";
            }
        }
        if (!sqlWhere.isEmpty()) {
            sqlWhere = " Where " + sqlWhere;
        }
        return sqlWhere;
    }

    public ResponseEntity<?> customerExists(HttpServletRequest request) {
        TncJdbc jdbc = this.dbConnection.getJdbcTemplate(this.dbConnection.setToken());
        if (!jdbc.getLogin().getIsTorfehNegar().booleanValue()) {
            return null;
        }
        String sql = "SELECT Top 1 C_CODE FROM CUSTOMER WHERE ";
        Map info = ConvertStr.rebuildQueryString((HttpServletRequest)request);
        String sqlWhere = "";
        if (info.containsKey("bedsarfasl")) {
            sqlWhere = sqlWhere + " Col_Code_Bed + Moien_Code_Bed + Tafzili_Code_Bed = '" + (String)info.get("bedsarfasl") + "'";
        }
        if (info.containsKey("nationalid")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " AND ";
            }
            sqlWhere = sqlWhere + " Isnull(National_Code, 0) = '" + (String)info.get("nationalid") + "'";
        }
        sql = sql + sqlWhere + " ORDER BY C_CODE ";
        SqlRowSet rs = jdbc.queryForRowSet(sql);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("result", rs.next() ? ConvertStr.encrypt((String)rs.getString("C_CODE")) : null);
        return ResponseEntity.ok(result);
    }

    public CustomerDao(DbConnection dbConnection, ScriptRunner scriptRunner, HolooSettingsDao settingDao, Application app) {
        this.dbConnection = dbConnection;
        this.scriptRunner = scriptRunner;
        this.settingDao = settingDao;
        this.app = app;
    }

    private static /* synthetic */ Boolean lambda$postCustomerList$2(JdbcTemplate jdbcTemplate, StringBuilder finalSb, List failure, TransactionStatus transactionStatus) {
        try {
            jdbcTemplate.execute(finalSb.toString());
            return true;
        }
        catch (Exception ex) {
            transactionStatus.setRollbackOnly();
            TncException exception = new TncException(TncExceptionMessages.DATA_INPUT_ERROR);
            Map model = exception.getErrorMap();
            model.put("Error", exception.getMessage() + "\n" + ex.getCause());
            failure.add(model);
            return false;
        }
    }

    private /* synthetic */ ResponseEntity lambda$deleteCustomer$0(JdbcTemplate jdbcTemplate, LoginDto login, String[] decryptedCodes, String sql, List errors, List deletedErpCodes, TransactionStatus status) {
        try {
            String checkExist = "IF NOT EXISTS (SELECT * FROM DBO.SYSOBJECTS WHERE ID = OBJECT_ID(N'[DBO].[DeleteCustomer]') AND OBJECTPROPERTY(ID, N'IsProcedure') = 1) SELECT 1 AS SP_NOT_EXIST\n ELSE SELECT 0 AS SP_NOT_EXIST";
            boolean spNotExist = ConvertStr.nullSafeBool((Boolean)((Boolean)jdbcTemplate.queryForObject(checkExist, Boolean.class)));
            if (spNotExist) {
                throw new TncException(TncExceptionMessages.UPDATE_HOLOO);
            }
            CustomerProcessDao customerProcessDao = new CustomerProcessDao(this.dbConnection, login, "");
            SqlRowSet rs = jdbcTemplate.queryForRowSet("SELECT C_NAME, C_CODE FROM CUSTOMER WHERE C_CODE IN (" + ConvertStr.commaBindStringsWithQuotes(Arrays.asList(decryptedCodes)) + ")");
            while (rs.next()) {
                boolean isError;
                String cCode = rs.getString("C_CODE");
                String erpCode = ConvertStr.encrypt((String)cCode);
                Map result = jdbcTemplate.queryForMap(sql, new Object[]{cCode});
                boolean bl = isError = ConvertStr.nullSafeInt((Integer)((Integer)result.get("ErorrNum"))) != 0 || !ConvertStr.isNullOrEmpty((String)((String)result.get("Erorrtxt")));
                if (isError) {
                    result = this.makeDeleteErrorMessage(result);
                    result.put("ErpCode", erpCode);
                    errors.add(result);
                }
                deletedErpCodes.add(erpCode);
                customerProcessDao.insert((Object)CustomerDto.builder().id(cCode).name(rs.getString("C_NAME")).build(), ProcessDao.ProcessKind.DELETE);
            }
        }
        catch (TncException e) {
            status.setRollbackOnly();
            return ConvertStr.getMapResponseEntity((String)"Customer", Collections.singletonList(e.getErrorMap()), Collections.emptyList());
        }
        catch (Exception e) {
            status.setRollbackOnly();
            TncException exception = new TncException(TncExceptionMessages.DEFAULT_ERROR);
            return ConvertStr.getMapResponseEntity((String)"Customer", Collections.singletonList(exception.makeErrorWithCause((Throwable)e)), Collections.emptyList());
        }
        return ConvertStr.getMapResponseEntity((String)"Customer", (List)errors, Collections.singletonList(Collections.singletonMap("deleted", deletedErpCodes)));
    }
}

